/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.codec;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.Locale;
import org.apache.james.mime4j.codec.Base64OutputStream;
import org.apache.james.mime4j.util.CharsetUtil;

public class EncoderUtil {
    private static final byte[] BASE64_TABLE = Base64OutputStream.BASE64_TABLE;
    private static final char BASE64_PAD = '=';
    private static final BitSet Q_REGULAR_CHARS = EncoderUtil.initChars("=_?");
    private static final BitSet Q_RESTRICTED_CHARS = EncoderUtil.initChars("=_?\"#$%&'(),.:;<>@[\\]^`{|}~");
    private static final int MAX_USED_CHARACTERS = 50;
    private static final String ENC_WORD_PREFIX = "=?";
    private static final String ENC_WORD_SUFFIX = "?=";
    private static final int ENCODED_WORD_MAX_LENGTH = 75;
    private static final BitSet TOKEN_CHARS = EncoderUtil.initChars("()<>@,;:\\\"/[]?=");
    private static final BitSet ATEXT_CHARS = EncoderUtil.initChars("()<>@.,;:\\\"[]");

    private static BitSet initChars(String specials) {
        BitSet bs = new BitSet(128);
        int ch = 33;
        while (ch < 127) {
            if (specials.indexOf(ch) == -1) {
                bs.set(ch);
            }
            ch = (char)(ch + 1);
        }
        return bs;
    }

    private EncoderUtil() {
    }

    public static String encodeAddressDisplayName(String displayName) {
        if (EncoderUtil.isAtomPhrase(displayName)) {
            return displayName;
        }
        if (EncoderUtil.hasToBeEncoded(displayName, 0)) {
            return EncoderUtil.encodeEncodedWord(displayName, Usage.WORD_ENTITY);
        }
        return EncoderUtil.quote(displayName);
    }

    public static String encodeAddressLocalPart(String localPart) {
        if (EncoderUtil.isDotAtomText(localPart)) {
            return localPart;
        }
        return EncoderUtil.quote(localPart);
    }

    public static String encodeHeaderParameter(String name, String value) {
        name = name.toLowerCase(Locale.US);
        if (EncoderUtil.isToken(value)) {
            return String.valueOf(name) + "=" + value;
        }
        return String.valueOf(name) + "=" + EncoderUtil.quote(value);
    }

    public static String encodeIfNecessary(String text, Usage usage, int usedCharacters) {
        if (EncoderUtil.hasToBeEncoded(text, usedCharacters)) {
            return EncoderUtil.encodeEncodedWord(text, usage, usedCharacters);
        }
        return text;
    }

    public static boolean hasToBeEncoded(String text, int usedCharacters) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        if (usedCharacters < 0 || usedCharacters > 50) {
            throw new IllegalArgumentException();
        }
        int nonWhiteSpaceCount = usedCharacters;
        int idx = 0;
        while (idx < text.length()) {
            char ch = text.charAt(idx);
            if (ch == '\t' || ch == ' ') {
                nonWhiteSpaceCount = 0;
            } else {
                if (++nonWhiteSpaceCount > 77) {
                    return true;
                }
                if (ch < ' ' || ch >= '\u007f') {
                    return true;
                }
            }
            ++idx;
        }
        return false;
    }

    public static String encodeEncodedWord(String text, Usage usage) {
        return EncoderUtil.encodeEncodedWord(text, usage, 0, null, null);
    }

    public static String encodeEncodedWord(String text, Usage usage, int usedCharacters) {
        return EncoderUtil.encodeEncodedWord(text, usage, usedCharacters, null, null);
    }

    public static String encodeEncodedWord(String text, Usage usage, int usedCharacters, Charset charset, Encoding encoding) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        if (usedCharacters < 0 || usedCharacters > 50) {
            throw new IllegalArgumentException();
        }
        if (charset == null) {
            charset = EncoderUtil.determineCharset(text);
        }
        byte[] bytes = EncoderUtil.encode(text, charset);
        if (encoding == null) {
            encoding = EncoderUtil.determineEncoding(bytes, usage);
        }
        if (encoding == Encoding.B) {
            String prefix = ENC_WORD_PREFIX + charset.name() + "?B?";
            return EncoderUtil.encodeB(prefix, text, usedCharacters, charset, bytes);
        }
        String prefix = ENC_WORD_PREFIX + charset.name() + "?Q?";
        return EncoderUtil.encodeQ(prefix, text, usage, usedCharacters, charset, bytes);
    }

    public static String encodeB(byte[] bytes) {
        int data;
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        int end = bytes.length;
        while (idx < end - 2) {
            data = (bytes[idx] & 0xFF) << 16 | (bytes[idx + 1] & 0xFF) << 8 | bytes[idx + 2] & 0xFF;
            sb.append((char)BASE64_TABLE[data >> 18 & 0x3F]);
            sb.append((char)BASE64_TABLE[data >> 12 & 0x3F]);
            sb.append((char)BASE64_TABLE[data >> 6 & 0x3F]);
            sb.append((char)BASE64_TABLE[data & 0x3F]);
            idx += 3;
        }
        if (idx == end - 2) {
            data = (bytes[idx] & 0xFF) << 16 | (bytes[idx + 1] & 0xFF) << 8;
            sb.append((char)BASE64_TABLE[data >> 18 & 0x3F]);
            sb.append((char)BASE64_TABLE[data >> 12 & 0x3F]);
            sb.append((char)BASE64_TABLE[data >> 6 & 0x3F]);
            sb.append('=');
        } else if (idx == end - 1) {
            data = (bytes[idx] & 0xFF) << 16;
            sb.append((char)BASE64_TABLE[data >> 18 & 0x3F]);
            sb.append((char)BASE64_TABLE[data >> 12 & 0x3F]);
            sb.append('=');
            sb.append('=');
        }
        return sb.toString();
    }

    public static String encodeQ(byte[] bytes, Usage usage) {
        BitSet qChars = usage == Usage.TEXT_TOKEN ? Q_REGULAR_CHARS : Q_RESTRICTED_CHARS;
        StringBuilder sb = new StringBuilder();
        int end = bytes.length;
        int idx = 0;
        while (idx < end) {
            int v = bytes[idx] & 0xFF;
            if (v == 32) {
                sb.append('_');
            } else if (!qChars.get(v)) {
                sb.append('=');
                sb.append(EncoderUtil.hexDigit(v >>> 4));
                sb.append(EncoderUtil.hexDigit(v & 0xF));
            } else {
                sb.append((char)v);
            }
            ++idx;
        }
        return sb.toString();
    }

    public static boolean isToken(String str) {
        int length = str.length();
        if (length == 0) {
            return false;
        }
        int idx = 0;
        while (idx < length) {
            char ch = str.charAt(idx);
            if (!TOKEN_CHARS.get(ch)) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    private static boolean isAtomPhrase(String str) {
        boolean containsAText = false;
        int length = str.length();
        int idx = 0;
        while (idx < length) {
            char ch = str.charAt(idx);
            if (ATEXT_CHARS.get(ch)) {
                containsAText = true;
            } else if (!CharsetUtil.isWhitespace(ch)) {
                return false;
            }
            ++idx;
        }
        return containsAText;
    }

    private static boolean isDotAtomText(String str) {
        int prev = 46;
        int length = str.length();
        if (length == 0) {
            return false;
        }
        int idx = 0;
        while (idx < length) {
            char ch = str.charAt(idx);
            if (ch == '.' ? prev == 46 || idx == length - 1 : !ATEXT_CHARS.get(ch)) {
                return false;
            }
            prev = ch;
            ++idx;
        }
        return true;
    }

    private static String quote(String str) {
        String escaped = str.replaceAll("[\\\\\"]", "\\\\$0");
        return "\"" + escaped + "\"";
    }

    private static String encodeB(String prefix, String text, int usedCharacters, Charset charset, byte[] bytes) {
        int encodedLength = EncoderUtil.bEncodedLength(bytes);
        int totalLength = prefix.length() + encodedLength + ENC_WORD_SUFFIX.length();
        if (totalLength <= 75 - usedCharacters) {
            return String.valueOf(prefix) + EncoderUtil.encodeB(bytes) + ENC_WORD_SUFFIX;
        }
        String part1 = text.substring(0, text.length() / 2);
        byte[] bytes1 = EncoderUtil.encode(part1, charset);
        String word1 = EncoderUtil.encodeB(prefix, part1, usedCharacters, charset, bytes1);
        String part2 = text.substring(text.length() / 2);
        byte[] bytes2 = EncoderUtil.encode(part2, charset);
        String word2 = EncoderUtil.encodeB(prefix, part2, 0, charset, bytes2);
        return String.valueOf(word1) + " " + word2;
    }

    private static int bEncodedLength(byte[] bytes) {
        return (bytes.length + 2) / 3 * 4;
    }

    private static String encodeQ(String prefix, String text, Usage usage, int usedCharacters, Charset charset, byte[] bytes) {
        int encodedLength = EncoderUtil.qEncodedLength(bytes, usage);
        int totalLength = prefix.length() + encodedLength + ENC_WORD_SUFFIX.length();
        if (totalLength <= 75 - usedCharacters) {
            return String.valueOf(prefix) + EncoderUtil.encodeQ(bytes, usage) + ENC_WORD_SUFFIX;
        }
        String part1 = text.substring(0, text.length() / 2);
        byte[] bytes1 = EncoderUtil.encode(part1, charset);
        String word1 = EncoderUtil.encodeQ(prefix, part1, usage, usedCharacters, charset, bytes1);
        String part2 = text.substring(text.length() / 2);
        byte[] bytes2 = EncoderUtil.encode(part2, charset);
        String word2 = EncoderUtil.encodeQ(prefix, part2, usage, 0, charset, bytes2);
        return String.valueOf(word1) + " " + word2;
    }

    private static int qEncodedLength(byte[] bytes, Usage usage) {
        BitSet qChars = usage == Usage.TEXT_TOKEN ? Q_REGULAR_CHARS : Q_RESTRICTED_CHARS;
        int count = 0;
        int idx = 0;
        while (idx < bytes.length) {
            int v = bytes[idx] & 0xFF;
            count = v == 32 ? ++count : (!qChars.get(v) ? (count += 3) : ++count);
            ++idx;
        }
        return count;
    }

    private static byte[] encode(String text, Charset charset) {
        ByteBuffer buffer = charset.encode(text);
        byte[] bytes = new byte[buffer.limit()];
        buffer.get(bytes);
        return bytes;
    }

    private static Charset determineCharset(String text) {
        boolean ascii = true;
        int len = text.length();
        int index = 0;
        while (index < len) {
            char ch = text.charAt(index);
            if (ch > '\u00ff') {
                return CharsetUtil.UTF_8;
            }
            if (ch > '\u007f') {
                ascii = false;
            }
            ++index;
        }
        return ascii ? CharsetUtil.US_ASCII : CharsetUtil.ISO_8859_1;
    }

    private static Encoding determineEncoding(byte[] bytes, Usage usage) {
        if (bytes.length == 0) {
            return Encoding.Q;
        }
        BitSet qChars = usage == Usage.TEXT_TOKEN ? Q_REGULAR_CHARS : Q_RESTRICTED_CHARS;
        int qEncoded = 0;
        int i = 0;
        while (i < bytes.length) {
            int v = bytes[i] & 0xFF;
            if (v != 32 && !qChars.get(v)) {
                ++qEncoded;
            }
            ++i;
        }
        int percentage = qEncoded * 100 / bytes.length;
        return percentage > 30 ? Encoding.B : Encoding.Q;
    }

    private static char hexDigit(int i) {
        return i < 10 ? (char)(i + 48) : (char)(i - 10 + 65);
    }

    public static enum Encoding {
        B,
        Q;

    }

    public static enum Usage {
        TEXT_TOKEN,
        WORD_ENTITY;

    }
}

