/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.smtp;

public class SimpleSMTPHeader {
    private String __subject;
    private String __from;
    private StringBuilder __headerFields;
    private StringBuilder __cc;
    private StringBuilder __bcc;
    private StringBuilder __to = null;

    public SimpleSMTPHeader(String from, String subject) {
        this.__from = from;
        this.__subject = subject;
        this.__headerFields = new StringBuilder();
        this.__cc = null;
    }

    public void addHeaderField(String headerField, String value) {
        this.__headerFields.append(headerField);
        this.__headerFields.append(": ");
        this.__headerFields.append(value);
        this.__headerFields.append("\r\n");
    }

    public void addCC(String address) {
        if (this.__cc == null) {
            this.__cc = new StringBuilder();
        } else {
            this.__cc.append(", ");
        }
        this.__cc.append(address);
    }

    public void addBCC(String address) {
        if (this.__bcc == null) {
            this.__bcc = new StringBuilder();
        } else {
            this.__bcc.append(", ");
        }
        this.__bcc.append(address);
    }

    public void addTo(String address) {
        if (this.__to == null) {
            this.__to = new StringBuilder();
        } else {
            this.__to.append(", ");
        }
        this.__to.append(address);
    }

    public String toString() {
        StringBuilder header = new StringBuilder();
        if (this.__headerFields.length() > 0) {
            header.append(this.__headerFields.toString());
        }
        header.append("From: ");
        header.append(this.__from);
        if (this.__to != null) {
            header.append("\r\nTo: ");
            header.append(this.__to.toString());
        }
        if (this.__cc != null) {
            header.append("\r\nCc: ");
            header.append(this.__cc.toString());
        }
        if (this.__bcc != null) {
            header.append("\r\nBcc: ");
            header.append(this.__bcc.toString());
        }
        if (this.__subject != null) {
            header.append("\r\nSubject: ");
            header.append(this.__subject);
        }
        header.append("\r\n");
        header.append("\r\n");
        return header.toString();
    }
}

