/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.smtp;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.net.io.CRLFLineReader;
import org.apache.commons.net.smtp.SMTPClient;
import org.apache.commons.net.smtp.SMTPReply;
import org.apache.commons.net.util.Base64;

public class AuthenticatingSMTPClient
extends SMTPClient {
    public AuthenticatingSMTPClient() throws NoSuchAlgorithmException {
        super("UTF8");
    }

    public int ehlo(String hostname) throws IOException {
        return this.sendCommand(15, hostname);
    }

    public boolean elogin(String hostname) throws IOException {
        return SMTPReply.isPositiveCompletion(this.ehlo(hostname));
    }

    public boolean elogin() throws IOException {
        InetAddress host = this.getLocalAddress();
        String name = host.getHostName();
        if (name == null) {
            return false;
        }
        return SMTPReply.isPositiveCompletion(this.ehlo(name));
    }

    public int[] getEnhancedReplyCode() {
        String reply = this.getReplyString().substring(4);
        String[] parts = reply.substring(0, reply.indexOf(32)).split("\\.");
        int[] res = new int[parts.length];
        int i = 0;
        while (i < parts.length) {
            res[i] = Integer.parseInt(parts[i]);
            ++i;
        }
        return res;
    }

    public boolean auth(AUTH_METHOD method, String username, String password) throws IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        if (!SMTPReply.isPositiveIntermediate(this.sendCommand(14, AUTH_METHOD.getAuthName(method)))) {
            return false;
        }
        if (method.equals((Object)AUTH_METHOD.PLAIN)) {
            return SMTPReply.isPositiveCompletion(this.sendCommand(new String(Base64.encodeBase64(("\u0000" + username + "\u0000" + password).getBytes()))));
        }
        if (method.equals((Object)AUTH_METHOD.CRAM_MD5)) {
            byte[] serverChallenge = Base64.decodeBase64(this.getReplyString().substring(4).trim());
            Mac hmac_md5 = Mac.getInstance("HmacMD5");
            hmac_md5.init(new SecretKeySpec(password.getBytes(), "HmacMD5"));
            byte[] hmacResult = this._convertToHexString(hmac_md5.doFinal(serverChallenge)).getBytes();
            byte[] usernameBytes = username.getBytes();
            byte[] toEncode = new byte[usernameBytes.length + 1 + hmacResult.length];
            System.arraycopy(usernameBytes, 0, toEncode, 0, usernameBytes.length);
            toEncode[usernameBytes.length] = 32;
            System.arraycopy(hmacResult, 0, toEncode, usernameBytes.length + 1, hmacResult.length);
            return SMTPReply.isPositiveCompletion(this.sendCommand(new String(Base64.encodeBase64(toEncode))));
        }
        if (method.equals((Object)AUTH_METHOD.LOGIN)) {
            if (!SMTPReply.isPositiveIntermediate(this.sendCommand(new String(Base64.encodeBase64(username.getBytes()))))) {
                return false;
            }
            return SMTPReply.isPositiveCompletion(this.sendCommand(new String(Base64.encodeBase64(password.getBytes()))));
        }
        return false;
    }

    private String _convertToHexString(byte[] a) {
        StringBuilder result = new StringBuilder(a.length * 2);
        int i = 0;
        while (i < a.length) {
            if ((a[i] & 0xFF) <= 15) {
                result.append("0");
            }
            result.append(Integer.toHexString(a[i] & 0xFF));
            ++i;
        }
        return result.toString();
    }

    public void execTLS(TrustManager[] custom) throws SSLException, IOException {
        if (!SMTPReply.isPositiveCompletion(this.sendCommand("STARTTLS"))) {
            throw new SSLException(this.getReplyString());
        }
        this.performSSLNegotiation(custom);
    }

    private void performSSLNegotiation(TrustManager[] custom) throws IOException {
        SSLContext context = this.SSLContextFromTrustManager(custom);
        SSLSocketFactory ssf = context.getSocketFactory();
        String ip = this.getRemoteAddress().getHostAddress();
        int port = this.getRemotePort();
        this._socket_.setSoTimeout(60000);
        SSLSocket socket = (SSLSocket)ssf.createSocket(this._socket_, ip, port, true);
        socket.setEnableSessionCreation(true);
        socket.setUseClientMode(true);
        socket.startHandshake();
        socket.setSoTimeout(this._timeout_);
        this._socket_ = socket;
        this._input_ = socket.getInputStream();
        this._output_ = socket.getOutputStream();
        this._reader = new CRLFLineReader(new InputStreamReader(this._input_, this.encoding));
        this._writer = new BufferedWriter(new OutputStreamWriter(this._output_, this.encoding));
    }

    public static enum AUTH_METHOD {
        PLAIN,
        CRAM_MD5,
        LOGIN;


        public static final String getAuthName(AUTH_METHOD method) {
            if (method.equals((Object)PLAIN)) {
                return "PLAIN";
            }
            if (method.equals((Object)CRAM_MD5)) {
                return "CRAM-MD5";
            }
            if (method.equals((Object)LOGIN)) {
                return "LOGIN";
            }
            return null;
        }
    }
}

