/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;

public class StringUtils {
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";
    private static final char SLASH_CHAR = '/';
    private static final char BACKSLASH_CHAR = '\\';

    public static StringBuffer stringSubstitution(String argStr, Map<? super String, ?> vars, boolean isLenient) {
        StringBuffer argBuf = new StringBuffer();
        if (argStr == null || argStr.length() == 0) {
            return argBuf;
        }
        if (vars == null || vars.size() == 0) {
            return argBuf.append(argStr);
        }
        int argStrLength = argStr.length();
        int cIdx = 0;
        while (cIdx < argStrLength) {
            char ch = argStr.charAt(cIdx);
            int del = 32;
            switch (ch) {
                case '$': {
                    StringBuilder nameBuf = new StringBuilder();
                    del = argStr.charAt(cIdx + 1);
                    if (del == 123) {
                        ++cIdx;
                        ++cIdx;
                        while (cIdx < argStr.length()) {
                            ch = argStr.charAt(cIdx);
                            if (ch != '_' && ch != '.' && ch != '-' && ch != '+' && !Character.isLetterOrDigit(ch)) break;
                            nameBuf.append(ch);
                            ++cIdx;
                        }
                        if (nameBuf.length() >= 0) {
                            String value;
                            Object temp = vars.get(nameBuf.toString());
                            if (temp instanceof File) {
                                value = StringUtils.fixFileSeparatorChar(((File)temp).getAbsolutePath());
                            } else {
                                String string = value = temp != null ? temp.toString() : null;
                            }
                            if (value != null) {
                                argBuf.append(value);
                            } else if (isLenient) {
                                argBuf.append("${").append(nameBuf.toString()).append("}");
                            } else {
                                throw new RuntimeException("No value found for : " + nameBuf);
                            }
                            del = argStr.charAt(cIdx);
                            if (del != 125) {
                                throw new RuntimeException("Delimiter not found for : " + nameBuf);
                            }
                        }
                        ++cIdx;
                        break;
                    }
                    argBuf.append(ch);
                    ++cIdx;
                    break;
                }
                default: {
                    argBuf.append(ch);
                    ++cIdx;
                }
            }
        }
        return argBuf;
    }

    public static String[] split(String input, String splitChar) {
        StringTokenizer tokens = new StringTokenizer(input, splitChar);
        ArrayList<String> strList = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            strList.add(tokens.nextToken());
        }
        return strList.toArray(new String[strList.size()]);
    }

    public static String fixFileSeparatorChar(String arg) {
        return arg.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public static String toString(String[] strings, String separator) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < strings.length) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(strings[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String quoteArgument(String argument) {
        String cleanedArgument = argument.trim();
        while (cleanedArgument.startsWith(SINGLE_QUOTE) || cleanedArgument.startsWith(DOUBLE_QUOTE)) {
            cleanedArgument = cleanedArgument.substring(1);
        }
        while (cleanedArgument.endsWith(SINGLE_QUOTE) || cleanedArgument.endsWith(DOUBLE_QUOTE)) {
            cleanedArgument = cleanedArgument.substring(0, cleanedArgument.length() - 1);
        }
        StringBuilder buf = new StringBuilder();
        if (cleanedArgument.indexOf(DOUBLE_QUOTE) > -1) {
            if (cleanedArgument.indexOf(SINGLE_QUOTE) > -1) {
                throw new IllegalArgumentException("Can't handle single and double quotes in same argument");
            }
            return buf.append(SINGLE_QUOTE).append(cleanedArgument).append(SINGLE_QUOTE).toString();
        }
        if (cleanedArgument.indexOf(SINGLE_QUOTE) > -1 || cleanedArgument.indexOf(" ") > -1) {
            return buf.append(DOUBLE_QUOTE).append(cleanedArgument).append(DOUBLE_QUOTE).toString();
        }
        return cleanedArgument;
    }

    public static boolean isQuoted(String argument) {
        return argument.startsWith(SINGLE_QUOTE) && argument.endsWith(SINGLE_QUOTE) || argument.startsWith(DOUBLE_QUOTE) && argument.endsWith(DOUBLE_QUOTE);
    }
}

