/*
 * Decompiled with CFR 0.152.
 */
package ir.hitex.zip;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.collections.List;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.progress.ProgressMonitor;

@BA.ShortName(value="HitexZIP")
@BA.Version(value=2.1f)
@BA.Author(value="Sadeq Nameni (Hitexroid)")
public class HitexZip
extends AbsObjectWrapper<ZipFile> {
    public int AES_STRENGTH_128 = 1;
    public int AES_STRENGTH_192 = 2;
    public int AES_STRENGTH_256 = 3;
    public int COMP_AES_ENC = 99;
    public int COMP_DEFLATE = 8;
    public int COMP_STORE = 0;
    public int ENC_METHOD_AES = 99;
    public int ENC_METHOD_STANDARD = 0;
    public int ENC_NO_ENCRYPTION = -1;
    public int DEFLATE_LEVEL_FASTEST = 1;
    public int DEFLATE_LEVEL_MAXIMUM = 7;
    public int DEFLATE_LEVEL_NORMAL = 5;
    public int DEFLATE_LEVEL_FAST = 3;
    public int DEFLATE_LEVEL_ULTRA = 9;
    public int RESULT_ERROR;
    public int RESULT_SUCCESS;
    public int RESULT_CANCELLED;
    public int RESULT_WORKING;
    public String LastErrorMessage;
    private int CompressionMethod1;
    private int CompressionLevel1;
    private int EncryptionMethod1;
    private int AesKeyStrength1;
    private BA ba;
    private String EventName;
    private Boolean IsFirsTime = true;
    private ProgressMonitor progressMonitor;
    private Boolean RunInThread = true;
    private String PassWord = "null";
    private String Dir;

    public void Initialize(BA bA, String string, String string2, String string3) throws ZipException, IOException {
        this.ba = bA;
        this.Dir = string;
        this.EventName = string3.toLowerCase(BA.cul);
        this.setObject(new ZipFile(this.getRealPath(string, string2)));
    }

    private String getRealPath(String string, String string2) throws IOException {
        if (string.equals(anywheresoftware.b4a.objects.streams.File.getDirAssets())) {
            if (anywheresoftware.b4a.objects.streams.File.virtualAssetsFolder != null) {
                return anywheresoftware.b4a.objects.streams.File.Combine(anywheresoftware.b4a.objects.streams.File.virtualAssetsFolder, anywheresoftware.b4a.objects.streams.File.getUnpackedVirtualAssetFile((String)string2));
            }
            return "file:///android_asset/" + string2;
        }
        return anywheresoftware.b4a.objects.streams.File.Combine(string, string2);
    }

    public void setRunInThread(Boolean bl) {
        this.RunInThread = bl;
    }

    public void setPassWord(String string) {
        this.PassWord = string;
    }

    public void ExtractAll(String string) {
        this.LastErrorMessage = "";
        try {
            ((ZipFile)this.getObject()).setRunInThread(this.RunInThread);
            if (((ZipFile)this.getObject()).isEncrypted()) {
                ((ZipFile)this.getObject()).setPassword(this.PassWord);
            }
            ((ZipFile)this.getObject()).extractAll(string);
            this.progressMonitor = ((ZipFile)this.getObject()).getProgressMonitor();
            while (this.progressMonitor.getState() == 1) {
                this.ba.raiseEventFromDifferentThread(this.getObject(), (Object)null, 0, this.EventName + "_zipdone", false, new Object[]{this.progressMonitor.getFileName(), this.progressMonitor.getPercentDone()});
            }
        }
        catch (ZipException zipException) {
            BA.Log("ExtractAll Error " + zipException.toString().substring(zipException.toString().lastIndexOf(":")));
            this.LastErrorMessage = "ExtractAll Error " + zipException.toString().substring(zipException.toString().lastIndexOf(":"));
        }
    }

    public void setComment(String string) {
        try {
            ((ZipFile)this.getObject()).setComment(string);
        }
        catch (ZipException zipException) {
            this.LastErrorMessage = zipException.getMessage();
        }
    }

    public String GetComment(String string) {
        try {
            if (string != null) {
                return ((ZipFile)this.getObject()).getComment(string);
            }
            return ((ZipFile)this.getObject()).getComment();
        }
        catch (ZipException zipException) {
            this.LastErrorMessage = zipException.getMessage();
            return null;
        }
    }

    public void AddFolder(String string) {
        if (this.Dir == anywheresoftware.b4a.objects.streams.File.getDirAssets()) {
            throw new IllegalStateException("Assets folder not supports this type of operation ! \n move or copy your zip file to another location and try again .");
        }
        this.LastErrorMessage = "";
        ((ZipFile)this.getObject()).setRunInThread(this.RunInThread);
        ZipParameters zipParameters = new ZipParameters();
        zipParameters.setCompressionMethod(8);
        zipParameters.setCompressionLevel(5);
        ArrayList arrayList = new ArrayList();
        try {
            ((ZipFile)this.getObject()).addFolder(string, zipParameters);
        }
        catch (ZipException zipException) {
            this.LastErrorMessage = zipException.getMessage();
        }
        ProgressMonitor progressMonitor = ((ZipFile)this.getObject()).getProgressMonitor();
        while (progressMonitor.getState() == 1) {
            this.ba.raiseEventFromDifferentThread(this.getObject(), (Object)null, 0, this.EventName + "_zipdone", false, new Object[]{progressMonitor.getFileName(), progressMonitor.getPercentDone()});
        }
    }

    public void AddFiles(List list) {
        if (this.Dir == anywheresoftware.b4a.objects.streams.File.getDirAssets()) {
            throw new IllegalStateException("Assets folder not supports this type of operation ! \n move or copy your zip file to another location and try again .");
        }
        this.LastErrorMessage = "";
        ((ZipFile)this.getObject()).setRunInThread(this.RunInThread);
        ZipParameters zipParameters = new ZipParameters();
        zipParameters.setCompressionMethod(8);
        zipParameters.setCompressionLevel(5);
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Object e : (java.util.List)list.getObject()) {
            arrayList.add(new File((String)e));
            BA.Log((String)e);
        }
        try {
            ((ZipFile)this.getObject()).addFiles(arrayList, zipParameters);
        }
        catch (ZipException zipException) {
            this.LastErrorMessage = zipException.getMessage();
        }
        ProgressMonitor progressMonitor = ((ZipFile)this.getObject()).getProgressMonitor();
        while (progressMonitor.getState() == 1) {
            this.ba.raiseEventFromDifferentThread(this.getObject(), (Object)null, 0, this.EventName + "_zipdone", false, new Object[]{progressMonitor.getFileName(), progressMonitor.getPercentDone()});
        }
    }

    public int getResult() {
        this.RESULT_ERROR = 2;
        this.RESULT_SUCCESS = 0;
        this.RESULT_WORKING = 1;
        this.RESULT_CANCELLED = 3;
        return this.progressMonitor.getResult();
    }

    public void RemoveFiles(String string) {
        this.LastErrorMessage = "";
        try {
            ((ZipFile)this.getObject()).setRunInThread(this.RunInThread);
            if (((ZipFile)this.getObject()).isEncrypted()) {
                ((ZipFile)this.getObject()).setPassword(this.PassWord);
            }
            ((ZipFile)this.getObject()).removeFile(string);
            ProgressMonitor progressMonitor = ((ZipFile)this.getObject()).getProgressMonitor();
            while (progressMonitor.getState() == 1) {
                this.ba.raiseEventFromDifferentThread(this.getObject(), (Object)null, 0, this.EventName + "_zipdone", false, new Object[]{progressMonitor.getFileName(), progressMonitor.getPercentDone()});
            }
        }
        catch (ZipException zipException) {
            zipException.printStackTrace();
            this.LastErrorMessage = "ExtractFiles Error " + zipException.toString().substring(zipException.toString().lastIndexOf(":"));
        }
    }

    public void ExtractFiles(String string, String string2) {
        this.LastErrorMessage = "";
        try {
            ((ZipFile)this.getObject()).setRunInThread(this.RunInThread);
            if (((ZipFile)this.getObject()).isEncrypted()) {
                ((ZipFile)this.getObject()).setPassword(this.PassWord);
            }
            ((ZipFile)this.getObject()).extractFile(string, string2);
            ProgressMonitor progressMonitor = ((ZipFile)this.getObject()).getProgressMonitor();
            while (progressMonitor.getState() == 1) {
                this.ba.raiseEventFromDifferentThread(this.getObject(), (Object)null, 0, this.EventName + "_zipdone", false, new Object[]{progressMonitor.getFileName(), progressMonitor.getPercentDone()});
            }
        }
        catch (ZipException zipException) {
            zipException.printStackTrace();
            this.LastErrorMessage = "ExtractFiles Error " + zipException.toString().substring(zipException.toString().lastIndexOf(":"));
        }
    }

    public Boolean getIsEncrypted() {
        try {
            return ((ZipFile)this.getObject()).isEncrypted();
        }
        catch (ZipException zipException) {
            BA.LogError(zipException.getMessage());
            return false;
        }
    }

    public Boolean getIsValidZipFile() {
        return ((ZipFile)this.getObject()).isValidZipFile();
    }

    public String LongConvertor(long l, boolean bl) {
        int n;
        int n2 = n = bl ? 1000 : 1024;
        if (l < (long)n) {
            return l + " B";
        }
        int n3 = (int)(Math.log(l) / Math.log(n));
        String string = (bl ? "kMGTPE" : "KMGTPE").charAt(n3 - 1) + (bl ? "" : "i");
        return String.format("%.1f %sB", (double)l / Math.pow(n, n3), string);
    }

    public void setSetCompressionMethod(int n) {
        this.CompressionMethod1 = n;
    }

    public void setSetCompressionLevel(int n) {
        this.CompressionLevel1 = n;
    }

    public void setSetEncryptionMethod(int n) {
        this.EncryptionMethod1 = n;
    }

    public void setSetAesKeyStrength(int n) {
        this.AesKeyStrength1 = n;
    }

    public List GetFileHeaders() throws ZipException {
        List list = new List();
        list.Initialize();
        java.util.List list2 = null;
        try {
            list2 = ((ZipFile)this.getObject()).getFileHeaders();
        }
        catch (ZipException zipException) {
            zipException.printStackTrace();
        }
        assert (list2 != null);
        for (int i = 0; i <= list2.size() - 1; ++i) {
            FileHeader fileHeader = (FileHeader)list2.get(i);
            list.Add(fileHeader.getFileName());
        }
        return list;
    }

    private Boolean isDirectory(String string) {
        File file = new File(string);
        return file.isDirectory();
    }

    public void CreateZip(List list) {
        this.IsFirsTime = true;
        this.LastErrorMessage = "";
        try {
            ((ZipFile)this.getObject()).setRunInThread(this.RunInThread);
            ZipParameters zipParameters = new ZipParameters();
            zipParameters.setCompressionMethod(8);
            zipParameters.setCompressionLevel(5);
            if (this.CompressionLevel1 != 0) {
                zipParameters.setCompressionLevel(this.CompressionLevel1);
            }
            if (this.CompressionMethod1 != 0) {
                zipParameters.setCompressionMethod(this.CompressionMethod1);
            }
            if (this.AesKeyStrength1 != 0) {
                zipParameters.setAesKeyStrength(this.AesKeyStrength1);
            }
            if (this.PassWord != "null") {
                zipParameters.setEncryptFiles(true);
                if (this.EncryptionMethod1 != 0) {
                    zipParameters.setEncryptionMethod(this.EncryptionMethod1);
                } else {
                    zipParameters.setEncryptionMethod(0);
                }
                zipParameters.setPassword(this.PassWord);
            }
            if (((ZipFile)this.getObject()).getFile().exists()) {
                ((ZipFile)this.getObject()).getFile().delete();
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            for (int i = 0; i <= list.getSize() - 1; ++i) {
                if (this.isDirectory(list.Get(i).toString()).booleanValue()) {
                    ((ZipFile)this.getObject()).addFolder(list.Get(i).toString(), zipParameters);
                } else {
                    arrayList.add(new File((String)list.Get(i)));
                }
                BA.Log(list.Get(i).toString());
            }
            ((ZipFile)this.getObject()).addFiles(arrayList, zipParameters);
            ProgressMonitor progressMonitor = ((ZipFile)this.getObject()).getProgressMonitor();
            while (progressMonitor.getState() == 1) {
                this.ba.raiseEventFromDifferentThread(this.getObject(), (Object)null, 0, this.EventName + "_zipdone", false, new Object[]{progressMonitor.getFileName(), progressMonitor.getPercentDone()});
            }
            System.out.println("Result: " + progressMonitor.getResult());
            if (progressMonitor.getResult() == 2) {
                if (progressMonitor.getException() != null) {
                    progressMonitor.getException().printStackTrace();
                } else {
                    System.err.println("An error occurred without any exception");
                }
            }
        }
        catch (ZipException zipException) {
            zipException.printStackTrace();
            this.LastErrorMessage = "CreateZip Error " + zipException.toString().substring(zipException.toString().lastIndexOf(":"));
        }
    }
}

