/*
 * Decompiled with CFR 0.152.
 */
package com.b4a.manamsoftware.PersianDate;

import anywheresoftware.b4a.BA;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

@BA.ShortName(value="ManamPersianDate")
public class ManamPersianDate {
    private int day;
    private int month;
    private int year;
    private int jY;
    private int jM;
    private int jD;
    private int gY;
    private int gM;
    private int gD;
    private int leap;
    private int march;
    private int irYear;
    private int irMonth;
    private int irDay;
    private int gMonth;
    private int gDay;
    private int juYear;
    private int juMonth;
    private int juDay;
    private int JDN;
    private int gYear;

    public ManamPersianDate() {
        GregorianCalendar calendar = new GregorianCalendar();
        this.setGregorianDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public ManamPersianDate(int year, int month, int day) {
        this.setGregorianDate(year, month, day);
    }

    static double gmod(double n, double m) {
        return (n % m + m) % m;
    }

    static double[] kuwaiticalendar(boolean adjust) {
        Calendar today = Calendar.getInstance();
        int adj = 0;
        adj = adjust ? 0 : 1;
        if (adjust) {
            int adjustmili = 86400000 * adj;
            long todaymili = today.getTimeInMillis() + (long)adjustmili;
            today.setTimeInMillis(todaymili);
        }
        double day = today.get(5);
        double month = today.get(2);
        double year = today.get(1);
        double m = month + 1.0;
        double y = year;
        if (m < 3.0) {
            y -= 1.0;
            m += 12.0;
        }
        double a = Math.floor(y / 100.0);
        double b = 2.0 - a + Math.floor(a / 4.0);
        if (y < 1583.0) {
            b = 0.0;
        }
        if (y == 1582.0) {
            if (m > 10.0) {
                b = -10.0;
            }
            if (m == 10.0) {
                b = 0.0;
                if (day > 4.0) {
                    b = -10.0;
                }
            }
        }
        double jd = Math.floor(365.25 * (y + 4716.0)) + Math.floor(30.6001 * (m + 1.0)) + day + b - 1524.0;
        b = 0.0;
        if (jd > 2299160.0) {
            a = Math.floor((jd - 1867216.25) / 36524.25);
            b = 1.0 + a - Math.floor(a / 4.0);
        }
        double bb = jd + b + 1524.0;
        double cc = Math.floor((bb - 122.1) / 365.25);
        double dd = Math.floor(365.25 * cc);
        double ee = Math.floor((bb - dd) / 30.6001);
        day = bb - dd - Math.floor(30.6001 * ee);
        month = ee - 1.0;
        if (ee > 13.0) {
            cc += 1.0;
            month = ee - 13.0;
        }
        year = cc - 4716.0;
        double wd = ManamPersianDate.gmod(jd + 1.0, 7.0) + 1.0;
        double iyear = 354.3666666666667;
        double epochastro = 1948084.0;
        double epochcivil = 1948085.0;
        double shift1 = 0.1335;
        double z = jd - epochastro;
        double cyc = Math.floor(z / 10631.0);
        double j = Math.floor(((z -= 10631.0 * cyc) - shift1) / iyear);
        double iy = 30.0 * cyc + j;
        double im = Math.floor(((z -= Math.floor(j * iyear + shift1)) + 28.5001) / 29.5);
        if (im == 13.0) {
            im = 12.0;
        }
        double id = z - Math.floor(29.5001 * im - 29.0);
        double[] myRes = new double[]{day, month - 1.0, year, jd - 1.0, wd - 1.0, id, im - 1.0, iy};
        return myRes;
    }

    public String getIslamicShortDate() {
        String[] iMonthNames = new String[]{"Muharram", "Safar", "Rabi'ul Awwal", "Rabi'ul Akhir", "Jumadal Ula", "Jumadal Akhira", "Rajab", "Sha'ban", "Ramadan", "Shawwal", "Dhul Qa'ada", "Dhul Hijja"};
        boolean dayTest = true;
        double[] iDate = ManamPersianDate.kuwaiticalendar(dayTest);
        String nMah = iMonthNames[(int)iDate[6]];
        int Rooz = 0;
        if (nMah == "Muharram") {
            Rooz = (int)iDate[5] - 2;
        }
        if (nMah == "Safar") {
            Rooz = (int)iDate[5] - 1;
        }
        if (nMah == "Rabi'ul Awwal") {
            Rooz = (int)iDate[5] - 2;
        }
        if (nMah == "Rabi'ul Akhir") {
            Rooz = (int)iDate[5] - 1;
        }
        if (nMah == "Jumadal Ula") {
            Rooz = (int)iDate[5] - 1;
        }
        if (nMah == "Jumadal Akhira") {
            Rooz = (int)iDate[5];
        }
        if (nMah == "Rajab") {
            Rooz = (int)iDate[5] - 1;
        }
        if (nMah == "Sha'ban") {
            Rooz = (int)iDate[5];
        }
        if (nMah == "Ramadan") {
            Rooz = (int)iDate[5] - 1;
        }
        if (nMah == "Shawwal") {
            Rooz = (int)iDate[5] - 1;
        }
        if (nMah == "Dhul Qa'ada") {
            Rooz = (int)iDate[5] - 2;
        }
        if (nMah == "Dhul Hijja") {
            Rooz = (int)iDate[5] - 1;
        }
        return String.format("%04d/%02d/%02d", (int)iDate[7], (int)iDate[6], Rooz);
    }

    public int getIslamicDay() {
        String[] iMonthNames = new String[]{"Muharram", "Safar", "Rabi'ul Awwal", "Rabi'ul Akhir", "Jumadal Ula", "Jumadal Akhira", "Rajab", "Sha'ban", "Ramadan", "Shawwal", "Dhul Qa'ada", "Dhul Hijja"};
        boolean dayTest = true;
        double[] iDate = ManamPersianDate.kuwaiticalendar(dayTest);
        String nMah = iMonthNames[(int)iDate[6]];
        int Rooz = 0;
        if (nMah == "Muharram") {
            Rooz = (int)iDate[5] - 2;
        }
        if (nMah == "Safar") {
            Rooz = (int)iDate[5] - 1;
        }
        if (nMah == "Rabi'ul Awwal") {
            Rooz = (int)iDate[5] - 2;
        }
        if (nMah == "Rabi'ul Akhir") {
            Rooz = (int)iDate[5] - 1;
        }
        if (nMah == "Jumadal Ula") {
            Rooz = (int)iDate[5] - 1;
        }
        if (nMah == "Jumadal Akhira") {
            Rooz = (int)iDate[5];
        }
        if (nMah == "Rajab") {
            Rooz = (int)iDate[5] - 1;
        }
        if (nMah == "Sha'ban") {
            Rooz = (int)iDate[5];
        }
        if (nMah == "Ramadan") {
            Rooz = (int)iDate[5] - 1;
        }
        if (nMah == "Shawwal") {
            Rooz = (int)iDate[5] - 1;
        }
        if (nMah == "Dhul Qa'ada") {
            Rooz = (int)iDate[5] - 2;
        }
        if (nMah == "Dhul Hijja") {
            Rooz = (int)iDate[5] - 1;
        }
        return Rooz;
    }

    public int getDaysOfYear() {
        int totalDays = 0;
        totalDays = this.IsLeap(this.getPersianYear()) ? 366 : 365;
        return totalDays;
    }

    public int getDaysRemain() {
        int totalDays = 0;
        totalDays = this.IsLeap(this.getPersianYear()) ? 366 : 365;
        return totalDays - this.getDayOfYear();
    }

    public int getDayOfYear() {
        Calendar calendar = Calendar.getInstance();
        int dayOfYear = calendar.get(6);
        return dayOfYear;
    }

    public int getIslamicMonth() {
        String[] iMonthNames = new String[]{"Muharram", "Safar", "Rabi'ul Awwal", "Rabi'ul Akhir", "Jumadal Ula", "Jumadal Akhira", "Rajab", "Sha'ban", "Ramadan", "Shawwal", "Dhul Qa'ada", "Dhul Hijja"};
        boolean dayTest = true;
        double[] iDate = ManamPersianDate.kuwaiticalendar(dayTest);
        String nMah = iMonthNames[(int)iDate[6]];
        int Rooz = 0;
        if (nMah == "Muharram") {
            Rooz = (int)iDate[5] - 2;
        }
        if (nMah == "Safar") {
            Rooz = (int)iDate[5] - 1;
        }
        if (nMah == "Rabi'ul Awwal") {
            Rooz = (int)iDate[5] - 2;
        }
        if (nMah == "Rabi'ul Akhir") {
            Rooz = (int)iDate[5] - 1;
        }
        if (nMah == "Jumadal Ula") {
            Rooz = (int)iDate[5] - 1;
        }
        if (nMah == "Jumadal Akhira") {
            Rooz = (int)iDate[5];
        }
        if (nMah == "Rajab") {
            Rooz = (int)iDate[5] - 1;
        }
        if (nMah == "Sha'ban") {
            Rooz = (int)iDate[5];
        }
        if (nMah == "Ramadan") {
            Rooz = (int)iDate[5] - 1;
        }
        if (nMah == "Shawwal") {
            Rooz = (int)iDate[5] - 1;
        }
        if (nMah == "Dhul Qa'ada") {
            Rooz = (int)iDate[5] - 2;
        }
        if (nMah == "Dhul Hijja") {
            Rooz = (int)iDate[5] - 1;
        }
        return (int)iDate[6];
    }

    public String getIslamicLongDate() {
        String[] wdNames = new String[]{"Ahad", "Ithnin", "Thulatha", "Arbaa", "Khams", "Jumuah", "Sabt"};
        String[] iMonthNames = new String[]{"Muharram", "Safar", "Rabi'ul Awwal", "Rabi'ul Akhir", "Jumadal Ula", "Jumadal Akhira", "Rajab", "Sha'ban", "Ramadan", "Shawwal", "Dhul Qa'ada", "Dhul Hijja"};
        boolean dayTest = true;
        double[] iDate = ManamPersianDate.kuwaiticalendar(dayTest);
        int Rooz = 0;
        String nMah = iMonthNames[(int)iDate[6]];
        String Mah = "";
        String Rozname = "";
        if (nMah == "Muharram") {
            Rooz = (int)iDate[5] - 2;
            Mah = "\u0645\u062d\u0631\u0645";
        }
        if (nMah == "Safar") {
            Rooz = (int)iDate[5] - 1;
            Mah = "\u0635\u0641\u0631";
        }
        if (nMah == "Rabi'ul Awwal") {
            Rooz = (int)iDate[5] - 2;
            Mah = "\u0631\u0628\u06cc\u0639 \u0627\u0644\u0627\u0648\u0644";
        }
        if (nMah == "Rabi'ul Akhir") {
            Rooz = (int)iDate[5] - 1;
            Mah = "\u0631\u0628\u06cc\u0639 \u0627\u0644\u062b\u0627\u0646\u06cc";
        }
        if (nMah == "Jumadal Ula") {
            Rooz = (int)iDate[5] - 1;
            Mah = "\u062c\u0645\u0627\u062f\u06cc \u0627\u0644\u0627\u0648\u0644";
        }
        if (nMah == "Jumadal Akhira") {
            Rooz = (int)iDate[5];
            Mah = "\u062c\u0645\u0627\u062f\u06cc \u0627\u0644\u062b\u0627\u0646\u06cc";
        }
        if (nMah == "Rajab") {
            Rooz = (int)iDate[5] - 1;
            Mah = "\u0631\u062c\u0628";
        }
        if (nMah == "Sha'ban") {
            Rooz = (int)iDate[5];
            Mah = "\u0634\u0639\u0628\u0627\u0646";
        }
        if (nMah == "Ramadan") {
            Rooz = (int)iDate[5] - 1;
            Mah = "\u0631\u0645\u0636\u0627\u0646";
        }
        if (nMah == "Shawwal") {
            Rooz = (int)iDate[5] - 1;
            Mah = "\u0634\u0648\u0627\u0644";
        }
        if (nMah == "Dhul Qa'ada") {
            Rooz = (int)iDate[5] - 2;
            Mah = "\u0630\u06cc\u0642\u0639\u062f\u0647";
        }
        if (nMah == "Dhul Hijja") {
            Rooz = (int)iDate[5] - 1;
            Mah = "\u0630\u06cc\u062d\u062c\u0647";
        }
        if (wdNames[(int)iDate[4]] == "Ahad") {
            Rozname = "\u0627\u0644\u0627\u062d\u062f";
        }
        if (wdNames[(int)iDate[4]] == "Ithnin") {
            Rozname = "\u0627\u0644\u0627\u062b\u0646\u06cc\u0646";
        }
        if (wdNames[(int)iDate[4]] == "Thulatha") {
            Rozname = "\u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621";
        }
        if (wdNames[(int)iDate[4]] == "Arbaa") {
            Rozname = "\u0627\u0644\u0627\u0631\u0628\u0639\u0627\u0621";
        }
        if (wdNames[(int)iDate[4]] == "Khams") {
            Rozname = "\u0627\u0644\u062e\u0645\u06cc\u0633";
        }
        if (wdNames[(int)iDate[4]] == "Jumuah") {
            Rozname = "\u0627\u0644\u062c\u0645\u0639\u0647";
        }
        if (wdNames[(int)iDate[4]] == "Sabt") {
            Rozname = "\u0627\u0644\u0633\u0628\u062a";
        }
        return String.valueOf(Rozname) + " , " + Rooz + " " + Mah + " " + (int)iDate[7];
    }

    public String AddDaysToGregorianDate(String GregorianDate, int days) throws ParseException {
        String dt = GregorianDate;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        Calendar c = Calendar.getInstance();
        c.setTime(sdf.parse(dt));
        c.add(5, days);
        dt = sdf.format(c.getTime());
        return dt;
    }

    public String AddDaysToPersianDate(String PersianDate, int days) throws ParseException {
        String[] parts = PersianDate.split("/");
        String sal = parts[0];
        String mah = parts[1];
        String Rooz = parts[2];
        int jd = this.Jal2JD(Integer.parseInt(sal), Integer.parseInt(mah), Integer.parseInt(Rooz));
        this.JD2JG(jd, 0);
        String dt = String.valueOf(this.gY) + "/" + this.gM + "/" + this.gD;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        Calendar c = Calendar.getInstance();
        c.setTime(sdf.parse(dt));
        c.add(5, days);
        dt = sdf.format(c.getTime());
        String[] persian = dt.split("/");
        String pDate = this.GregorianToPersian(Integer.parseInt(persian[0]), Integer.parseInt(persian[1]), Integer.parseInt(persian[2]));
        return pDate;
    }

    public int getPersianYear() {
        return this.irYear;
    }

    private void setGregorianDate(int year, int month, int day) {
        this.gYear = year;
        this.gMonth = month;
        this.gDay = day;
        this.JDN = this.gregorianDateToJDN(year, month, day);
        this.JDNToIranian();
        this.JDNToJulian();
        this.JDNToGregorian();
    }

    public int getPersianMonth() {
        return this.irMonth;
    }

    public String About() {
        return "\u2665 Manam Persian Date Ver 1.6 \u2665 \n_________________________________ \n \nDeveloper : Ali Dakhilzadeh \n\n\u25ba For Any Question About This Library Please Contact Me By My Personal Email : \n \nalimanam@gmail.com \n\n Enjoy from your life  \u263a \n";
    }

    public String getPersianLongDate() {
        int mah = this.irMonth;
        String NameMah = "";
        if (mah == 1) {
            NameMah = "\u0641\u0631\u0648\u0631\u062f\u06cc\u0646";
        }
        if (mah == 2) {
            NameMah = "\u0627\u0631\u062f\u06cc\u0628\u0647\u0634\u062a";
        }
        if (mah == 3) {
            NameMah = "\u062e\u0631\u062f\u0627\u062f";
        }
        if (mah == 4) {
            NameMah = "\u062a\u06cc\u0631";
        }
        if (mah == 5) {
            NameMah = "\u0645\u0631\u062f\u0627\u062f";
        }
        if (mah == 6) {
            NameMah = "\u0634\u0647\u0631\u06cc\u0648\u0631";
        }
        if (mah == 7) {
            NameMah = "\u0645\u0647\u0631";
        }
        if (mah == 8) {
            NameMah = "\u0622\u0628\u0627\u0646";
        }
        if (mah == 9) {
            NameMah = "\u0622\u0630\u0631";
        }
        if (mah == 10) {
            NameMah = "\u062f\u06cc";
        }
        if (mah == 11) {
            NameMah = "\u0628\u0647\u0645\u0646";
        }
        if (mah == 12) {
            NameMah = "\u0627\u0633\u0641\u0646\u062f";
        }
        return String.valueOf(this.getPersianDayName()) + ' ' + this.irDay + ' ' + NameMah + ' ' + this.getPersianYear();
    }

    public String getPersianMonthName() {
        int mah = this.irMonth;
        String NameMah = "";
        if (mah == 1) {
            NameMah = "\u0641\u0631\u0648\u0631\u062f\u06cc\u0646";
        }
        if (mah == 2) {
            NameMah = "\u0627\u0631\u062f\u06cc\u0628\u0647\u0634\u062a";
        }
        if (mah == 3) {
            NameMah = "\u062e\u0631\u062f\u0627\u062f";
        }
        if (mah == 4) {
            NameMah = "\u062a\u06cc\u0631";
        }
        if (mah == 5) {
            NameMah = "\u0645\u0631\u062f\u0627\u062f";
        }
        if (mah == 6) {
            NameMah = "\u0634\u0647\u0631\u06cc\u0648\u0631";
        }
        if (mah == 7) {
            NameMah = "\u0645\u0647\u0631";
        }
        if (mah == 8) {
            NameMah = "\u0622\u0628\u0627\u0646";
        }
        if (mah == 9) {
            NameMah = "\u0622\u0630\u0631";
        }
        if (mah == 10) {
            NameMah = "\u062f\u06cc";
        }
        if (mah == 11) {
            NameMah = "\u0628\u0647\u0645\u0646";
        }
        if (mah == 12) {
            NameMah = "\u0627\u0633\u0641\u0646\u062f";
        }
        return NameMah;
    }

    public String getGregorianDayName() {
        String[] weekDayStr = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
        return weekDayStr[this.getDayOfWeek()];
    }

    public int getIslamicYear() {
        boolean dayTest = true;
        double[] iDate = ManamPersianDate.kuwaiticalendar(dayTest);
        return (int)iDate[7];
    }

    public String getIslamicDayName() {
        String[] wdNames = new String[]{"Ahad", "Ithnin", "Thulatha", "Arbaa", "Khams", "Jumuah", "Sabt"};
        boolean dayTest = true;
        double[] iDate = ManamPersianDate.kuwaiticalendar(dayTest);
        String Rozname = "";
        if (wdNames[(int)iDate[4]] == "Ahad") {
            Rozname = "\u0627\u0644\u0627\u062d\u062f";
        }
        if (wdNames[(int)iDate[4]] == "Ithnin") {
            Rozname = "\u0627\u0644\u0627\u062b\u0646\u06cc\u0646";
        }
        if (wdNames[(int)iDate[4]] == "Thulatha") {
            Rozname = "\u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621";
        }
        if (wdNames[(int)iDate[4]] == "Arbaa") {
            Rozname = "\u0627\u0644\u0627\u0631\u0628\u0639\u0627\u0621";
        }
        if (wdNames[(int)iDate[4]] == "Khams") {
            Rozname = "\u0627\u0644\u062e\u0645\u06cc\u0633";
        }
        if (wdNames[(int)iDate[4]] == "Jumuah") {
            Rozname = "\u0627\u0644\u062c\u0645\u0639\u0647";
        }
        if (wdNames[(int)iDate[4]] == "Sabt") {
            Rozname = "\u0627\u0644\u0633\u0628\u062a";
        }
        return Rozname;
    }

    public String getIslamicMonthName() {
        String[] iMonthNames = new String[]{"Muharram", "Safar", "Rabi'ul Awwal", "Rabi'ul Akhir", "Jumadal Ula", "Jumadal Akhira", "Rajab", "Sha'ban", "Ramadan", "Shawwal", "Dhul Qa'ada", "Dhul Hijja"};
        boolean dayTest = true;
        double[] iDate = ManamPersianDate.kuwaiticalendar(dayTest);
        String nMah = iMonthNames[(int)iDate[6]];
        String Mah = "";
        if (nMah == "Muharram") {
            Mah = "\u0645\u062d\u0631\u0645";
        }
        if (nMah == "Safar") {
            Mah = "\u0635\u0641\u0631";
        }
        if (nMah == "Rabi'ul Awwal") {
            Mah = "\u0631\u0628\u06cc\u0639 \u0627\u0644\u0627\u0648\u0644";
        }
        if (nMah == "Rabi'ul Akhir") {
            Mah = "\u0631\u0628\u06cc\u0639 \u0627\u0644\u062b\u0627\u0646\u06cc";
        }
        if (nMah == "Jumadal Ula") {
            Mah = "\u062c\u0645\u0627\u062f\u06cc \u0627\u0644\u0627\u0648\u0644";
        }
        if (nMah == "Jumadal Akhira") {
            Mah = "\u062c\u0645\u0627\u062f\u06cc \u0627\u0644\u062b\u0627\u0646\u06cc";
        }
        if (nMah == "Rajab") {
            Mah = "\u0631\u062c\u0628";
        }
        if (nMah == "Sha'ban") {
            Mah = "\u0634\u0639\u0628\u0627\u0646";
        }
        if (nMah == "Ramadan") {
            Mah = "\u0631\u0645\u0636\u0627\u0646";
        }
        if (nMah == "Shawwal") {
            Mah = "\u0634\u0648\u0627\u0644";
        }
        if (nMah == "Dhul Qa'ada") {
            Mah = "\u0630\u06cc\u0642\u0639\u062f\u0647";
        }
        if (nMah == "Dhul Hijja") {
            Mah = "\u0630\u06cc\u062d\u062c\u0647";
        }
        return Mah;
    }

    public String getGregorianMonthNameFarsi() {
        int gm = this.gMonth;
        String ret = "";
        if (gm == 1) {
            ret = "\u0698\u0627\u0646\u0648\u06cc\u0647";
        }
        if (gm == 2) {
            ret = "\u0641\u0648\u0631\u06cc\u0647";
        }
        if (gm == 3) {
            ret = "\u0645\u0627\u0631\u0633";
        }
        if (gm == 4) {
            ret = "\u0622\u0648\u0631\u06cc\u0644";
        }
        if (gm == 5) {
            ret = "\u0645\u0647";
        }
        if (gm == 6) {
            ret = "\u0698\u0648\u0626\u0646";
        }
        if (gm == 7) {
            ret = "\u0698\u0648\u0626\u06cc\u0647";
        }
        if (gm == 8) {
            ret = "\u0622\u06af\u0648\u0633\u062a";
        }
        if (gm == 9) {
            ret = "\u0633\u067e\u062a\u0627\u0645\u0628\u0631";
        }
        if (gm == 10) {
            ret = "\u0627\u06a9\u062a\u0628\u0631";
        }
        if (gm == 11) {
            ret = "\u0646\u0648\u0627\u0645\u0628\u0631";
        }
        if (gm == 12) {
            ret = "\u062f\u0633\u0627\u0645\u0628\u0631";
        }
        return ret;
    }

    public String getGregorianMonthNameLatin() {
        int gm = this.gMonth;
        String ret = "";
        if (gm == 1) {
            ret = "January";
        }
        if (gm == 2) {
            ret = "February";
        }
        if (gm == 3) {
            ret = "March";
        }
        if (gm == 4) {
            ret = "April";
        }
        if (gm == 5) {
            ret = "May";
        }
        if (gm == 6) {
            ret = "June";
        }
        if (gm == 7) {
            ret = "July";
        }
        if (gm == 8) {
            ret = "August";
        }
        if (gm == 9) {
            ret = "September";
        }
        if (gm == 10) {
            ret = "October";
        }
        if (gm == 11) {
            ret = "November";
        }
        if (gm == 12) {
            ret = "December";
        }
        return ret;
    }

    private static long daysBetween(Calendar startDate, Calendar endDate) {
        Calendar date = (Calendar)startDate.clone();
        long daysBetween = 0L;
        while (date.before(endDate)) {
            date.add(5, 1);
            ++daysBetween;
        }
        return daysBetween;
    }

    public long CalculateDaysBetween(String startDate, String endDate) {
        Date sDate = new Date(startDate);
        Date eDate = new Date(endDate);
        Calendar cal3 = Calendar.getInstance();
        cal3.setTime(sDate);
        Calendar cal4 = Calendar.getInstance();
        cal4.setTime(eDate);
        return ManamPersianDate.daysBetween(cal3, cal4);
    }

    public int getPersianDay() {
        return this.irDay;
    }

    public String getGregorianYear() {
        return String.format("%04d", this.gYear);
    }

    public int getGregorianMonth() {
        return this.gMonth;
    }

    public int getGregorianDay() {
        return this.gDay;
    }

    public String getJulianYear() {
        return String.format("%04d", this.juYear);
    }

    public String getJulianMonth() {
        return String.format("%02d", this.juMonth);
    }

    public int getJulianDay() {
        return this.juDay;
    }

    public String getPersianShortDate() {
        return String.format("%04d/%02d/%02d", this.irYear, this.irMonth, this.irDay);
    }

    public String getGregorianDate() {
        return String.format("%04d/%02d/%02d", this.gYear, this.gMonth, this.gDay);
    }

    public String getJulianDate() {
        return String.format("%04d/%02d/%02d", this.juYear, this.juMonth, this.juDay);
    }

    public String getPersianDayName() {
        String[] weekDayStr = new String[]{"\u062f\u0648\u0634\u0646\u0628\u0647", "\u0633\u0647 \u0634\u0646\u0628\u0647", "\u0686\u0647\u0627\u0631\u0634\u0646\u0628\u0647", "\u067e\u0646\u062c\u0634\u0646\u0628\u0647", "\u062c\u0645\u0639\u0647", "\u0634\u0646\u0628\u0647", "\u06cc\u06a9\u0634\u0646\u0628\u0647"};
        return weekDayStr[this.getDayOfWeek()];
    }

    private int getDayOfWeek() {
        return this.JDN % 7;
    }

    private void IranianCalendar() {
        int jump;
        int jm;
        int[] Breaks = new int[]{-61, 9, 38, 199, 426, 686, 756, 818, 1111, 1181, 1210, 1635, 2060, 2097, 2192, 2262, 2324, 2394, 2456, 3178};
        this.gYear = this.irYear + 621;
        int leapJ = -14;
        int jp = Breaks[0];
        int j = 1;
        do {
            jm = Breaks[j];
            jump = jm - jp;
            if (this.irYear < jm) continue;
            leapJ += jump / 33 * 8 + jump % 33 / 4;
            jp = jm;
        } while (++j < 20 && this.irYear >= jm);
        int N = this.irYear - jp;
        leapJ += N / 33 * 8 + (N % 33 + 3) / 4;
        if (jump % 33 == 4 && jump - N == 4) {
            ++leapJ;
        }
        int leapG = this.gYear / 4 - (this.gYear / 100 + 1) * 3 / 4 - 150;
        this.march = 20 + leapJ - leapG;
        if (jump - N < 6) {
            N = N - jump + (jump + 4) / 33 * 33;
        }
        this.leap = ((N + 1) % 33 - 1) % 4;
        if (this.leap == -1) {
            this.leap = 4;
        }
    }

    private void JDNToIranian() {
        this.JDNToGregorian();
        this.irYear = this.gYear - 621;
        this.IranianCalendar();
        int JDN1F = this.gregorianDateToJDN(this.gYear, 3, this.march);
        int k = this.JDN - JDN1F;
        if (k >= 0) {
            if (k <= 185) {
                this.irMonth = 1 + k / 31;
                this.irDay = k % 31 + 1;
                return;
            }
            k -= 186;
        } else {
            --this.irYear;
            k += 179;
            if (this.leap == 1) {
                ++k;
            }
        }
        this.irMonth = 7 + k / 30;
        this.irDay = k % 30 + 1;
    }

    private void JDNToJulian() {
        int j = 4 * this.JDN + 139361631;
        int i = j % 1461 / 4 * 5 + 308;
        this.juDay = i % 153 / 5 + 1;
        this.juMonth = i / 153 % 12 + 1;
        this.juYear = j / 1461 - 100100 + (8 - this.juMonth) / 6;
    }

    private int gregorianDateToJDN(int year, int month, int day) {
        int jdn = (year + (month - 8) / 6 + 100100) * 1461 / 4 + (153 * ((month + 9) % 12) + 2) / 5 + day - 34840408;
        jdn = jdn - (year + 100100 + (month - 8) / 6) / 100 * 3 / 4 + 752;
        return jdn;
    }

    private void JDNToGregorian() {
        int j = 4 * this.JDN + 139361631;
        int i = (j += (4 * this.JDN + 183187720) / 146097 * 3 / 4 * 4 - 3908) % 1461 / 4 * 5 + 308;
        this.gDay = i % 153 / 5 + 1;
        this.gMonth = i / 153 % 12 + 1;
        this.gYear = j / 1461 - 100100 + (8 - this.gMonth) / 6;
    }

    private int JG2JD(int year, int month, int day, int J1G0) {
        int jd = 1461 * (year + 4800 + (month - 14) / 12) / 4 + 367 * (month - 2 - 12 * ((month - 14) / 12)) / 12 - 3 * ((year + 4900 + (month - 14) / 12) / 100) / 4 + day - 32075;
        if (J1G0 == 0) {
            jd = jd - (year + 100100 + (month - 8) / 6) / 100 * 3 / 4 + 752;
        }
        return jd;
    }

    private void JD2JG(int JD, int J1G0) {
        int j = 4 * JD + 139361631;
        if (J1G0 == 0) {
            j = j + (4 * JD + 183187720) / 146097 * 3 / 4 * 4 - 3908;
        }
        int i = j % 1461 / 4 * 5 + 308;
        this.gD = i % 153 / 5 + 1;
        this.gM = i / 153 % 12 + 1;
        this.gY = j / 1461 - 100100 + (8 - this.gM) / 6;
    }

    private void JD2Jal(int JDN) {
        this.JD2JG(JDN, 0);
        this.jY = this.gY - 621;
        this.JalCal(this.jY);
        int JDN1F = this.JG2JD(this.gY, 3, this.march, 0);
        int k = JDN - JDN1F;
        if (k >= 0) {
            if (k <= 185) {
                this.jM = 1 + k / 31;
                this.jD = k % 31 + 1;
                return;
            }
            k -= 186;
        } else {
            --this.jY;
            k += 179;
            if (this.leap == 1) {
                ++k;
            }
        }
        this.jM = 7 + k / 30;
        this.jD = k % 30 + 1;
    }

    private int Jal2JD(int jY, int jM, int jD) {
        this.JalCal(jY);
        int jd = this.JG2JD(this.gY, 3, this.march, 1) + (jM - 1) * 31 - jM / 7 * (jM - 7) + jD - 1;
        return jd;
    }

    private void JalCal(int jY) {
        this.march = 0;
        this.leap = 0;
        int[] breaks = new int[]{-61, 9, 38, 199, 426, 686, 756, 818, 1111, 1181, 1210, 1635, 2060, 2097, 2192, 2262, 2324, 2394, 2456, 3178};
        this.gY = jY + 621;
        int leapJ = -14;
        int jp = breaks[0];
        int jump = 0;
        int j = 1;
        while (j <= 19) {
            int jm = breaks[j];
            jump = jm - jp;
            if (jY < jm) {
                int N = jY - jp;
                leapJ = leapJ + N / 33 * 8 + (N % 33 + 3) / 4;
                if (jump % 33 == 4 && jump - N == 4) {
                    ++leapJ;
                }
                int leapG = this.gY / 4 - (this.gY / 100 + 1) * 3 / 4 - 150;
                this.march = 20 + leapJ - leapG;
                if (jump - N < 6) {
                    N = N - jump + (jump + 4) / 33 * 33;
                }
                this.leap = ((N + 1) % 33 - 1) % 4;
                if (this.leap != -1) break;
                this.leap = 4;
                break;
            }
            leapJ = leapJ + jump / 33 * 8 + jump % 33 / 4;
            jp = jm;
            ++j;
        }
    }

    public String GregorianToPersian(int year, int month, int day) {
        int jd = this.JG2JD(year, month, day, 0);
        this.JD2Jal(jd);
        this.year = this.jY;
        this.month = this.jM;
        this.day = this.jD;
        return String.format("%04d/%02d/%02d", this.year, this.month, this.day);
    }

    public String PersianToGregorian(int year, int month, int day) {
        int jd = this.Jal2JD(year, month, day);
        this.JD2JG(jd, 0);
        this.year = this.gY;
        this.month = this.gM;
        this.day = this.gD;
        return String.format("%04d/%02d/%02d", this.year, this.month, this.day);
    }

    public boolean IsLeap(int persianYear) {
        int jump;
        int jm;
        int[] Breaks = new int[]{-61, 9, 38, 199, 426, 686, 756, 818, 1111, 1181, 1210, 1635, 2060, 2097, 2192, 2262, 2324, 2394, 2456, 3178};
        this.gYear = persianYear + 621;
        int leapJ = -14;
        int jp = Breaks[0];
        int j = 1;
        do {
            jm = Breaks[j];
            jump = jm - jp;
            if (persianYear < jm) continue;
            leapJ += jump / 33 * 8 + jump % 33 / 4;
            jp = jm;
        } while (++j < 20 && persianYear >= jm);
        int N = persianYear - jp;
        leapJ += N / 33 * 8 + (N % 33 + 3) / 4;
        if (jump % 33 == 4 && jump - N == 4) {
            ++leapJ;
        }
        int leapG = this.gYear / 4 - (this.gYear / 100 + 1) * 3 / 4 - 150;
        this.march = 20 + leapJ - leapG;
        if (jump - N < 6) {
            N = N - jump + (jump + 4) / 33 * 33;
        }
        this.leap = ((N + 1) % 33 - 1) % 4;
        if (this.leap == -1) {
            this.leap = 4;
        }
        return this.leap == 4 || this.leap == 0;
    }
}

