/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.xui;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.keywords.Bit;
import anywheresoftware.b4a.keywords.Common;
import anywheresoftware.b4a.keywords.Regex;
import anywheresoftware.b4a.keywords.StringBuilderWrapper;
import anywheresoftware.b4j.objects.JFX;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.Node;
import javafx.scene.paint.Paint;

@BA.Hide
public class CSSUtils {
    private static Pattern rgba;

    public void SetBackgroundColor(Node node, Paint color) {
        this.SetStyleProperty(node, "-fx-background-color", this.ColorToHex(color));
    }

    public void SetBorder(Node node, double Width, Paint Color2, double CornerRadius) {
        this.SetStyleProperty(node, "-fx-border-color", this.ColorToHex(Color2));
        this.SetStyleProperty(node, "-fx-border-width", "" + Width);
        this.SetStyleProperty(node, "-fx-border-radius", "" + CornerRadius);
        this.SetStyleProperty(node, "-fx-background-radius", "" + CornerRadius);
    }

    public int GetColorFromProperty(Node node, String property, int defaultValue) {
        int b;
        int g;
        int r;
        String hex = this.GetStyleProperty(node, property);
        if (hex == "") {
            return defaultValue;
        }
        int a = 255;
        if (hex.startsWith("#")) {
            r = Integer.parseInt(hex.substring(1, 3), 16);
            g = Integer.parseInt(hex.substring(3, 5), 16);
            b = Integer.parseInt(hex.substring(5, 7), 16);
        } else {
            Matcher m;
            if (rgba == null) {
                rgba = Pattern.compile("rgba\\((\\d+),(\\d+),(\\d+),([\\d.]+)\\)");
            }
            if ((m = rgba.matcher(hex)).find()) {
                r = Integer.parseInt(m.group(1));
                g = Integer.parseInt(m.group(2));
                b = Integer.parseInt(m.group(3));
                a = Math.round(Float.parseFloat(m.group(4)) * 255.0f);
            } else {
                System.out.println("Cannot parse color string: " + hex);
                return defaultValue;
            }
        }
        return a << 24 | r << 16 | g << 8 | b;
    }

    public String ColorToHex(Paint _color) {
        int _c = 0;
        int _alpha = 0;
        int _red = 0;
        int _green = 0;
        int _blue = 0;
        StringBuilderWrapper _sb = null;
        _c = JFX.Colors.To32Bit(_color);
        _alpha = Bit.UnsignedShiftRight(_c, 24);
        _red = Bit.And(Bit.UnsignedShiftRight(_c, 16), 255);
        _green = Bit.And(Bit.UnsignedShiftRight(_c, 8), 255);
        _blue = Bit.And(_c, 255);
        _sb = new StringBuilderWrapper();
        _sb.Initialize();
        _sb.Append("rgba(").Append(BA.NumberToString(_red)).Append(",").Append(BA.NumberToString(_green)).Append(",").Append(BA.NumberToString(_blue)).Append(",");
        _sb.Append(Common.NumberFormat2((double)_alpha / 255.0, 1, 2, 2, false)).Append(")");
        return _sb.ToString();
    }

    public void SetStyleProperty(Node node, String key, String value) {
        String newStyle;
        String att = String.valueOf(key) + ":" + value + ";";
        Regex.MatcherWrapper m = Regex.Matcher(String.valueOf(key) + ":[^;]+;", node.getStyle());
        if (m.Find()) {
            newStyle = node.getStyle().substring(0, m.GetStart(0));
            newStyle = String.valueOf(newStyle) + att + node.getStyle().substring(m.GetEnd(0));
        } else {
            newStyle = String.valueOf(node.getStyle()) + att;
        }
        node.setStyle(newStyle);
    }

    public String GetStyleProperty(Node node, String key) {
        Regex.MatcherWrapper m = Regex.Matcher(String.valueOf(key) + ":([^;]+);", node.getStyle());
        if (m.Find()) {
            return m.Group(1);
        }
        return "";
    }
}

