/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.collections.Map;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;

@BA.Version(value=1.52f)
@BA.ShortName(value="Shell")
public class Shell {
    private DefaultExecutor exec;
    private CommandLine cl;
    private String encoding = "UTF8";
    private String eventName;
    private HashMap<String, String> envVars;
    private OutputStream outForProcessInputStream;
    private PipedInputStream processInputStream;
    private ByteArrayOutputStream tempOut;
    private ByteArrayOutputStream tempErr;

    public void Initialize(String EventName, String Executable2, anywheresoftware.b4a.objects.collections.List Args) {
        this.init(EventName, Executable2, Args, true);
    }

    public void InitializeDoNotHandleQuotes(String EventName, String Executable2, anywheresoftware.b4a.objects.collections.List Args) {
        this.init(EventName, Executable2, Args, false);
    }

    private void init(String EventName, String Executable2, anywheresoftware.b4a.objects.collections.List Args, boolean handle) {
        this.exec = new DefaultExecutor();
        this.exec.setExitValues(null);
        this.eventName = EventName.toLowerCase(BA.cul);
        this.cl = new CommandLine(Executable2);
        if (Args.IsInitialized()) {
            for (Object o : (List)Args.getObject()) {
                this.cl.addArgument((String)o, handle);
            }
        }
    }

    public boolean IsInitialized() {
        return this.exec != null;
    }

    public String getExecutable() {
        return this.cl.getExecutable();
    }

    public String[] getArguments() {
        return this.cl.getArguments();
    }

    public void SetEnvironmentVariables(Map Vars) {
        if (!Vars.IsInitialized()) {
            this.envVars = null;
        } else {
            this.envVars = new HashMap();
            for (Map.Entry<Object, Object> e : ((Map.MyMap)Vars.getObject()).entrySet()) {
                this.envVars.put(String.valueOf(e.getKey()), String.valueOf(e.getValue()));
            }
        }
    }

    public void setInputStreamEnabled(boolean b) throws IOException {
        if (b) {
            this.outForProcessInputStream = new PipedOutputStream();
            this.processInputStream = new PipedInputStream((PipedOutputStream)this.outForProcessInputStream);
        } else {
            this.outForProcessInputStream = null;
            this.processInputStream = null;
        }
    }

    public boolean getInputStreamEnabled() {
        return this.processInputStream != null;
    }

    public void WriteToInputStream(byte[] Data) throws IOException {
        this.outForProcessInputStream.write(Data);
    }

    public String getWorkingDirectory() {
        return this.exec.getWorkingDirectory().toString();
    }

    public void setWorkingDirectory(String s) {
        this.exec.setWorkingDirectory(new File(s));
    }

    public void setEncoding(String s) {
        this.encoding = s;
    }

    public void KillProcess() {
        this.exec.getWatchdog().destroyProcess();
    }

    public void Run(BA ba, long TimeoutMs) throws ExecuteException, IOException {
        this.tempOut = new ByteArrayOutputStream();
        this.tempErr = new ByteArrayOutputStream();
        this.run(ba, TimeoutMs, this.tempOut, this.tempErr);
    }

    public String GetTempOut() throws UnsupportedEncodingException {
        if (this.tempOut == null) {
            return "";
        }
        return new String(this.tempOut.toByteArray(), this.encoding);
    }

    public String GetTempErr() throws UnsupportedEncodingException {
        if (this.tempErr == null) {
            return "";
        }
        return new String(this.tempErr.toByteArray(), this.encoding);
    }

    public void RunWithOutputEvents(BA ba, long TimeoutMs) throws ExecuteException, IOException {
        this.run(ba, TimeoutMs, new EventOutput(ba, "_stdout"), new EventOutput(ba, "_stderr"));
    }

    public ShellSyncResult RunSynchronous(long TimeoutMs) throws IOException {
        ShellSyncResult sr = new ShellSyncResult();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        ExecuteWatchdog wd = new ExecuteWatchdog(TimeoutMs);
        this.exec.setWatchdog(wd);
        PumpStreamHandler p = new PumpStreamHandler(out, err, this.processInputStream);
        this.exec.setStreamHandler(p);
        try {
            sr.ExitCode = this.exec.execute(this.cl, this.envVars);
            sr.Success = true;
            sr.StdOut = new String(out.toByteArray(), this.encoding);
            sr.StdErr = new String(err.toByteArray(), this.encoding);
        }
        catch (ExecuteException e) {
            sr.Success = false;
            sr.StdErr = e.toString();
            sr.ExitCode = e.getExitValue();
        }
        return sr;
    }

    private void run(final BA ba, long TimeoutMs, final OutputStream out, final OutputStream err) throws ExecuteException, IOException {
        final ExecuteWatchdog wd = new ExecuteWatchdog(TimeoutMs);
        this.exec.setWatchdog(wd);
        PumpStreamHandler p = new PumpStreamHandler(out, err, this.processInputStream);
        p.setStopTimeout(500L);
        this.exec.setStreamHandler(p);
        this.exec.execute(this.cl, this.envVars, new ExecuteResultHandler(){

            @Override
            public void onProcessFailed(ExecuteException e) {
                ba.raiseEventFromDifferentThread((Object)Shell.this, (Object)null, 0, String.valueOf(Shell.this.eventName) + "_processcompleted", false, new Object[]{false, e.getExitValue(), "", e.toString()});
            }

            @Override
            public void onProcessComplete(int exitValue) {
                String eo;
                String so;
                try {
                    if (out instanceof ByteArrayOutputStream) {
                        so = new String(((ByteArrayOutputStream)out).toByteArray(), Shell.this.encoding);
                        eo = new String(((ByteArrayOutputStream)err).toByteArray(), Shell.this.encoding);
                    } else {
                        so = "";
                        eo = "";
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                boolean success = true;
                if (wd.killedProcess()) {
                    eo = "timeout";
                    success = false;
                }
                ba.raiseEventFromDifferentThread((Object)Shell.this, (Object)null, 0, String.valueOf(Shell.this.eventName) + "_processcompleted", false, new Object[]{success, exitValue, so, eo});
                Shell.this.exec = null;
            }
        });
    }

    class EventOutput
    extends OutputStream {
        private final BA ba;
        private final String event;

        public EventOutput(BA ba, String event) {
            this.ba = ba;
            this.event = event;
        }

        @Override
        public void write(int b) throws IOException {
            throw new RuntimeException("Not supported");
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.ba.raiseEvent2(Shell.this, false, String.valueOf(Shell.this.eventName) + this.event, false, b, len);
        }
    }

    @BA.ShortName(value="ShellSyncResult")
    public static class ShellSyncResult {
        public boolean Success;
        public int ExitCode;
        public String StdOut;
        public String StdErr;
    }
}

