/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.net;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.collections.Map;
import anywheresoftware.b4a.objects.streams.File;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.TrustManager;
import org.apache.commons.net.pop3.POP3Client;
import org.apache.commons.net.pop3.POP3MessageInfo;

@BA.ShortName(value="POP3")
public class POPWrapper
implements BA.CheckForReinitialize {
    private String user;
    private String password;
    private String server;
    private int port;
    private static int taskId;
    private String eventName;
    private boolean useSSL;
    private POP3Client client;
    private volatile int numberOfTasks;
    private ReentrantLock lock = new ReentrantLock(true);
    private TrustManager[] trustManager;

    public void Initialize(String Server, int Port, String Username, String Password, String EventName) {
        this.user = Username;
        this.password = Password;
        this.server = Server;
        this.port = Port;
        this.eventName = EventName.toLowerCase(BA.cul);
        this.numberOfTasks = 0;
        this.useSSL = false;
        this.client = new POP3Client();
    }

    @Override
    public boolean IsInitialized() {
        return this.client != null;
    }

    public void SetCustomSSLTrustManager(Object TrustManager2) {
        this.trustManager = (TrustManager[])TrustManager2;
    }

    public void setUseSSL(boolean b) {
        this.useSSL = b;
    }

    public boolean getUseSSL() {
        return this.useSSL;
    }

    private void connectIfNeeded(BA ba) throws Exception {
        if (this.client == null) {
            throw new RuntimeException("POP3 should first be initialized.");
        }
        if (!this.client.isConnected()) {
            if (this.useSSL) {
                this.client.setSSL(this.trustManager);
            }
            this.client.connect(this.server, this.port);
            if (!this.client.login(this.user, this.password)) {
                throw new RuntimeException("Error during login: " + this.client.getReplyString());
            }
        }
    }

    public Object ListMessages(final BA ba) {
        final int myTask = taskId++;
        ++this.numberOfTasks;
        final Object senderFilter = new Object();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Map m = new Map();
                m.Initialize();
                POPWrapper.this.lock.lock();
                try {
                    try {
                        POPWrapper.this.connectIfNeeded(ba);
                        POP3MessageInfo[] msgs = POPWrapper.this.client.listMessages();
                        if (msgs == null) {
                            throw new RuntimeException("Error listing messages: " + POPWrapper.this.client.getReplyString());
                        }
                        POP3MessageInfo[] pOP3MessageInfoArray = msgs;
                        int n = msgs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            POP3MessageInfo msg = pOP3MessageInfoArray[n2];
                            m.Put(msg.number, msg.size);
                            ++n2;
                        }
                        ba.raiseEventFromDifferentThread(senderFilter, (Object)POPWrapper.this, myTask, String.valueOf(POPWrapper.this.eventName) + "_listcompleted", false, new Object[]{true, m});
                    }
                    catch (Exception e) {
                        ba.setLastException(e);
                        ba.raiseEventFromDifferentThread(senderFilter, (Object)POPWrapper.this, myTask, String.valueOf(POPWrapper.this.eventName) + "_listcompleted", false, new Object[]{false, m});
                        try {
                            POPWrapper.this.CloseNow();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
                finally {
                    POPWrapper.this.endOfTask();
                }
            }
        };
        BA.submitRunnable(r, this, myTask);
        return senderFilter;
    }

    public Object Status(final BA ba) {
        final int myTask = taskId++;
        ++this.numberOfTasks;
        final Object senderFilter = new Object();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                POPWrapper.this.lock.lock();
                try {
                    try {
                        POPWrapper.this.connectIfNeeded(ba);
                        POP3MessageInfo p = POPWrapper.this.client.status();
                        if (p == null) {
                            throw new RuntimeException("Error g: " + POPWrapper.this.client.getReplyString());
                        }
                        ba.raiseEventFromDifferentThread(senderFilter, (Object)POPWrapper.this, myTask, String.valueOf(POPWrapper.this.eventName) + "_statuscompleted", false, new Object[]{true, p.number, p.size});
                    }
                    catch (Exception e) {
                        ba.setLastException(e);
                        ba.raiseEventFromDifferentThread(senderFilter, (Object)POPWrapper.this, myTask, String.valueOf(POPWrapper.this.eventName) + "_statuscompleted", false, new Object[]{false, 0, 0});
                        try {
                            POPWrapper.this.CloseNow();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
                finally {
                    POPWrapper.this.endOfTask();
                }
            }
        };
        BA.submitRunnable(r, this, myTask);
        return senderFilter;
    }

    public Object DownloadMessageTop(BA ba, int MessageId, int NumberOfLines, boolean Delete) {
        return this.downloadMessage(ba, MessageId, Delete, NumberOfLines);
    }

    public Object DownloadMessage(BA ba, int MessageId, boolean Delete) {
        return this.downloadMessage(ba, MessageId, Delete, -1);
    }

    private Object downloadMessage(final BA ba, final int MessageId, final boolean Delete, final int top) {
        final int myTask = taskId++;
        ++this.numberOfTasks;
        final Object senderFilter = new Object();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                POPWrapper.this.lock.lock();
                try {
                    try {
                        Reader reader;
                        POPWrapper.this.connectIfNeeded(ba);
                        if (top == -1 ? (reader = POPWrapper.this.client.retrieveMessage(MessageId)) == null : (reader = POPWrapper.this.client.retrieveMessageTop(MessageId, top)) == null) {
                            throw new RuntimeException("Error retrieving message: " + POPWrapper.this.client.getReplyString());
                        }
                        BufferedReader br = (BufferedReader)reader;
                        File.TextReaderWrapper t = new File.TextReaderWrapper();
                        t.setObject(br);
                        String msg = t.ReadAll();
                        if (Delete && !POPWrapper.this.client.deleteMessage(MessageId)) {
                            throw new RuntimeException("Error deleting message: " + POPWrapper.this.client.getReplyString());
                        }
                        ba.raiseEventFromDifferentThread(senderFilter, (Object)POPWrapper.this, myTask, String.valueOf(POPWrapper.this.eventName) + "_downloadcompleted", false, new Object[]{true, MessageId, msg});
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ba.setLastException(e);
                        ba.raiseEventFromDifferentThread(senderFilter, (Object)POPWrapper.this, myTask, String.valueOf(POPWrapper.this.eventName) + "_downloadcompleted", false, new Object[]{false, MessageId, ""});
                        try {
                            POPWrapper.this.CloseNow();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
                finally {
                    POPWrapper.this.endOfTask();
                }
            }
        };
        BA.submitRunnable(r, this, myTask);
        return senderFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endOfTask() {
        this.lock.unlock();
        --this.numberOfTasks;
        if (this.client != null && this.numberOfTasks == 0) {
            POP3Client pOP3Client = this.client;
            synchronized (pOP3Client) {
                this.client.notifyAll();
            }
        }
    }

    public void Close() {
        int myTask = taskId++;
        if (this.client == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                POP3Client pOP3Client = POPWrapper.this.client;
                synchronized (pOP3Client) {
                    while (true) {
                        if (POPWrapper.this.numberOfTasks <= 0 || POPWrapper.this.client == null) {
                            try {
                                POPWrapper.this.CloseNow();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        try {
                            POPWrapper.this.client.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    return;
                }
            }
        };
        BA.submitRunnable(runnable, this, myTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void CloseNow() throws IOException {
        if (this.client == null) {
            return;
        }
        if (this.client.isConnected()) {
            this.client.logout();
            this.client.disconnect();
        }
        POP3Client pOP3Client = this.client;
        synchronized (pOP3Client) {
            this.client.notifyAll();
        }
        this.client = null;
    }
}

