/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.streams.File;
import anywheresoftware.b4j.objects.NodeWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.util.Duration;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;

@BA.ShortName(value="ImageView")
public class ImageViewWrapper
extends NodeWrapper<ImageView> {
    @Override
    @BA.Hide
    public void innerInitialize(BA ba, String eventName, boolean keepOldObject) {
        if (!keepOldObject) {
            this.setObject(new ImageView());
        }
        super.innerInitialize(ba, eventName, true);
    }

    public double getWidth() {
        return ((ImageView)this.getObject()).getFitWidth();
    }

    public double getHeight() {
        return ((ImageView)this.getObject()).getFitHeight();
    }

    public void setWidth(double d) {
        ((ImageView)this.getObject()).setFitWidth(d);
    }

    public void setHeight(double d) {
        ((ImageView)this.getObject()).setFitHeight(d);
    }

    public void SetLayoutAnimated(int Duration2, double Left, double Top, double Width, double Height) {
        if (Duration2 == 0) {
            this.setTop(Top);
            this.setLeft(Left);
            this.setWidth(Width);
            this.setHeight(Height);
            this.raiseAnimationCompletedEvent(null, "SetLayoutAnimated");
            return;
        }
        KeyValue left = new KeyValue((WritableValue)((ImageView)this.getObject()).layoutXProperty(), (Object)(Left - ((ImageView)this.getObject()).getLayoutBounds().getMinX()));
        KeyValue top = new KeyValue((WritableValue)((ImageView)this.getObject()).layoutYProperty(), (Object)(Top - ((ImageView)this.getObject()).getLayoutBounds().getMinY()));
        KeyValue width = new KeyValue((WritableValue)((ImageView)this.getObject()).fitWidthProperty(), (Object)Width);
        KeyValue height = new KeyValue((WritableValue)((ImageView)this.getObject()).fitHeightProperty(), (Object)Height);
        KeyFrame frame = new KeyFrame(Duration.millis((double)Duration2), new KeyValue[]{left, top, width, height});
        Timeline timeline = new Timeline(new KeyFrame[]{frame});
        this.raiseAnimationCompletedEvent((Animation)timeline, "SetLayoutAnimated");
        timeline.play();
    }

    public boolean getPreserveRatio() {
        return ((ImageView)this.getObject()).isPreserveRatio();
    }

    public void setPreserveRatio(boolean b) {
        ((ImageView)this.getObject()).setPreserveRatio(b);
    }

    public ImageWrapper GetImage() {
        return (ImageWrapper)AbsObjectWrapper.ConvertToWrapper(new ImageWrapper(), ((ImageView)this.getObject()).getImage());
    }

    public void SetImage(Image Image2) {
        ((ImageView)this.getObject()).setImage(Image2);
    }

    @BA.Hide
    public static Node build(Object prev, HashMap<String, Object> props, boolean designer, Object tag) throws Exception {
        Node vg = (Node)prev;
        if (vg == null) {
            vg = (Node)NodeWrapper.buildNativeView(ImageView.class, props, designer);
        }
        ImageView pb = (ImageView)NodeWrapper.build(vg, props, designer);
        pb.setPreserveRatio(((Boolean)props.get("preserveRatio")).booleanValue());
        return pb;
    }

    @BA.ShortName(value="Image")
    public static class ImageWrapper
    extends AbsObjectWrapper<Image> {
        public void Initialize(String Dir, String FileName) throws IOException {
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream in = (InputStream)File.OpenInput(Dir, FileName).getObject();){
                this.Initialize2(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public void Initialize2(InputStream In) {
            Image img = new Image(In);
            this.setObject(img);
        }

        public void InitializeSample(String Dir, String FileName, double Width, double Height) throws IOException {
            Throwable throwable = null;
            Object var8_7 = null;
            try (InputStream in = (InputStream)File.OpenInput(Dir, FileName).getObject();){
                Image img = new Image(in, Width, Height, false, true);
                this.setObject(img);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public void InitializeSample2(InputStream In, double Width, double Height) throws IOException {
            Image img = new Image(In, Width, Height, false, true);
            this.setObject(img);
        }

        public double getWidth() {
            return ((Image)this.getObject()).getWidth();
        }

        public double getHeight() {
            return ((Image)this.getObject()).getHeight();
        }

        public int GetPixel(int x, int y) {
            return ((Image)this.getObject()).getPixelReader().getArgb(x, y);
        }

        public void WriteToStream(OutputStream Out) throws IOException {
            String ImageFormat = "png";
            Iterator<ImageWriter> iiw = ImageIO.getImageWritersByFormatName(ImageFormat);
            if (!iiw.hasNext()) {
                throw new RuntimeException("No writer found for: " + ImageFormat);
            }
            ImageWriter iw = iiw.next();
            ImageWriteParam param = iw.getDefaultWriteParam();
            iw.setOutput(ImageIO.createImageOutputStream(Out));
            iw.write(null, new IIOImage(SwingFXUtils.fromFXImage((Image)((Image)this.getObject()), null), null, null), param);
        }
    }
}

